//
//  MCCSWHeaderView.h
//  CollapsibleWidget
//
//  Created by Michael Clark on 11/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCCollapsibleSheetWidget;

@interface MCCSWHeaderView : NSView {

	NSString*     __titleString;
	
	NSColor*      __bgColor;
	NSColor*      __textColor;
	
	NSImage*      __bgLeftCapImage; 
	NSImage*      __bgRightCapImage;
	NSImageCell*  __bgMiddleImageCell;
	
	NSImage*      __circleButton[2]; // 0 - normal, 1 - Pressed
	
	NSProgressIndicator *progressIndicator;
	
	BOOL          __mouseDownInClose;
	
	BOOL          __drawCloseButton;
	NSRect        __closeButtonRect;
	BOOL          __drawDisclosureTriangle;
	NSRect        __disclosureTriangleRect;
	BOOL          __mouseDownInDisclosure;

	NSRect        __dragRect;
	BOOL          __mouseDownInDragRect;

	BOOL          _usesSystemColor;
}

- (id)initWithFrame:(NSRect)frame;


- (MCCollapsibleSheetWidget*)widget;

- (NSString *)titleString;
- (void)setTitleString:(NSString *)aTitleString;



- (MCCollapsibleSheetWidget*)parentWidget;

- (void)startProgressIndicator;
- (void)stopProgressIndicator;

- (NSColor *)bgColor;
- (void)setBgColor:(NSColor *)aBgColor;
- (NSColor *)textColor;
- (void)setTextColor:(NSColor *)aTextColor;

- (BOOL)usesSystemColor;
- (void)setUsesSystemColor:(BOOL)flag;

- (BOOL)drawCloseButton;
- (void)setDrawCloseButton:(BOOL)flag;
- (BOOL)drawDisclosureTriangle;
- (void)setDrawDisclosureTriangle:(BOOL)flag;

- (NSProgressIndicator *)progressIndicator;
- (void)setProgressIndicator:(NSProgressIndicator *)aProgressIndicator;
@end
